<?php
include("authenticate.php");

// check to see if user is logging out
if(isset($_GET['out'])) {
	// destroy session
	session_unset();
	$_SESSION = array();
	unset($_SESSION['user'],$_SESSION['access']);
	session_destroy();
}

// check to see if login form has been submitted
if(isset($_POST['userLogin'])){
	// run information through authenticator
	if(authenticate($_POST['userLogin'],$_POST['userPassword']))
	{
		// authentication passed
		header("Location: index.php");
		die();
	} else {
		// authentication failed
		$error = 1;
	}
}

// output logout success
if(isset($_GET['out'])) echo "Logout successful";
?>

<html>
<head>
  <title>Flat Admin V.3 - Free flat-design bootstrap administrator templates</title>
  

  <link rel="stylesheet" type="text/css" href="../assets/css/vendor.css">
  <link rel="stylesheet" type="text/css" href="../assets/css/flat-admin.css">

  <!-- Theme -->
  <link rel="stylesheet" type="text/css" href="../assets/css/theme/blue-sky.css">
  <link rel="stylesheet" type="text/css" href="../assets/css/theme/blue.css">
  <link rel="stylesheet" type="text/css" href="../assets/css/theme/red.css">
  <link rel="stylesheet" type="text/css" href="../assets/css/theme/yellow.css">

</head>
<body>
  <div class="app app-default">

<div class="app-container app-login">
  <div class="flex-center">
<?php
if (isset($error)) {
?>
<div>
	<div class="alert alert-danger alert-dismissible" role-"alert">
                <center><strong> Oh Snap!</strong><br/>Invalid Credentials try again</center>
	</div>
<?php
}
?>
    <div class="app-header"></div>
    <div class="app-body">
      <div class="loader-container text-center">
          <div class="icon">
            <div class="sk-folding-cube">
                <div class="sk-cube1 sk-cube"></div>
                <div class="sk-cube2 sk-cube"></div>
                <div class="sk-cube4 sk-cube"></div>
                <div class="sk-cube3 sk-cube"></div>
              </div>
            </div>
          <div class="title">Logging in...</div>
      </div>
      <div class="app-block">
      <div class="app-form">
        <div class="form-header">
          <div class="app-brand"><span class="highlight">Hostirian</span> Expo</div>
        </div>
        <form action="login.php" method="post">
            <div class="input-group">
              <span class="input-group-addon" id="basic-addon1">
                <i class="fa fa-user" aria-hidden="true"></i></span>
              <input type="text" class="form-control"  placeholder="Username" name='userLogin'>
            </div>
            <div class="input-group">
              <span class="input-group-addon" id="basic-addon2">
                <i class="fa fa-key" aria-hidden="true"></i></span>
              <input type="password" class="form-control" placeholder="Password" name='userPassword'>
            </div>
            <div class="text-center">
                <input type="submit"  class="btn btn-success btn" value="Login">
            </div>
        </form>

        <div class="form-footer">
        </div>
      </div>
      </div>
    </div>
    <div class="app-footer">
    </div>
  </div>
</div>
</div>
  </div>
  
<!--<script type="text/javascript" src="../assets/js/vendor.js"></script>-->
  <script type="text/javascript" src="../assets/js/app.js"></script>

</body>
</html>
